import 'package:viserpay_agent/core/utils/method.dart';
import 'package:viserpay_agent/core/utils/url_container.dart';
import 'package:viserpay_agent/data/model/global/response_model/response_model.dart';
import 'package:viserpay_agent/data/services/api_service.dart';

class CommissionLogRepo{

  ApiClient apiClient;
  CommissionLogRepo({required this.apiClient});

  Future<ResponseModel> getCommissionLogData(int page) async{
    String url = "${UrlContainer.baseUrl}${UrlContainer.commissionLogEndPoint}?page=$page";
    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return responseModel;
  }
}